definition module bounceTypes


import	StdInt, StdClass, StdPicture, StdIOCommon


::	Barrel
	=	{	bBase	:: Point			// the base point of the barrel
		,	bWalls	:: [Wall]			// the walls of the barrel
		,	bDomain	:: BarrelDomain		// the enclosing rectangular area of the barrel
		}
::	Wall
	:==	(	!Vector						// the displacement of the wall (a la Polygon)
		,	!Interior					// the sign at what side the wall faces the interior
		)
::	SingleWall
	:==	(	!Line						// the exact pixel position of the wall
		,	!Interior
		)
::	Line			:==	(!Point,!Point)
::	BarrelDomain	:== Rectangle
::	Interior		:== Int
::	Scale			:==	(!Real,!Real)	// (horizontal scale, vertical scale)
::	Radius			:== Int

::	Ball
	=	{	bCenter	:: Point			// the center of the ball
		,	bRadius	:: Radius			// the radius of the ball
		,	bSpeed	:: Vector			// the direction and speed of the ball
		,	bColour	:: Colour			// the colour of the ball
		}

rightBarrelSetUp	:: (Barrel,[Ball])
leftBarrelSetUp		:: (Barrel,[Ball])
BarrelToPolygon		:: !Scale !Barrel -> (!Point,!Polygon)
splitWallsInBarrel	:: !Barrel -> (![SingleWall],![SingleWall])

between				:: !a !a !a			-> Bool		| Ord a
dist				:: !Point !Point	-> Real
scaleSize			:: !Size !Size		-> Scale
